/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.stats;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.localization.AchievementStrings;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.screens.mainMenu.MenuCancelButton;
import com.megacrit.cardcrawl.screens.stats.AchievementGrid;
import com.megacrit.cardcrawl.screens.stats.CharStat;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatsScreen {
    private static final Logger logger = LogManager.getLogger(StatsScreen.class.getName());
    private static final AchievementStrings achievementStrings = CardCrawlGame.languagePack.getAchievementString("StatsScreen");
    public static final String[] NAMES = StatsScreen.achievementStrings.NAMES;
    public static final String[] TEXT = StatsScreen.achievementStrings.TEXT;
    public MenuCancelButton button = new MenuCancelButton();
    public AbstractPlayer.PlayerClass currentChar = null;
    public boolean screenUp = false;
    private static final float SHOW_X = 300.0f * Settings.scale;
    private static final float HIDE_X = -800.0f * Settings.scale;
    private float screenX = HIDE_X;
    private float targetX = HIDE_X;
    private boolean grabbedScreen = false;
    private float grabStartY = 0.0f;
    private float scrollTargetY = 0.0f;
    private float scrollY = 0.0f;
    private float renderY;
    private float scrollLowerBound = -Settings.DEFAULT_SCROLL_LIMIT;
    private float scrollUpperBound = Settings.DEFAULT_SCROLL_LIMIT;
    private static CharStat all;
    private static CharStat ironclad;
    private static CharStat silent;
    private static CharStat crowbot;
    private static AchievementGrid achievements;

    public StatsScreen() {
        this.refreshData();
        this.calculateScrollBounds();
    }

    public void refreshData() {
        ironclad = new CharStat(AbstractPlayer.PlayerClass.IRONCLAD);
        silent = new CharStat(AbstractPlayer.PlayerClass.THE_SILENT);
        crowbot = new CharStat(AbstractPlayer.PlayerClass.CROWBOT);
        ArrayList<CharStat> allChars = new ArrayList<CharStat>();
        allChars.add(ironclad);
        allChars.add(silent);
        all = new CharStat(allChars);
        achievements = new AchievementGrid();
        Settings.totalPlayTime = StatsScreen.all.playTime;
    }

    public void update() {
        this.button.update();
        if (this.button.hb.clicked || InputHelper.pressedEscape) {
            InputHelper.pressedEscape = false;
            CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.MAIN_MENU;
            this.hide();
        }
        this.screenX = MathHelper.uiLerpSnap(this.screenX, this.targetX);
        this.updateScrolling();
        achievements.update();
    }

    private void updateScrolling() {
        int y = InputHelper.mY;
        if (!this.grabbedScreen) {
            if (InputHelper.scrolledDown) {
                this.scrollTargetY += Settings.SCROLL_SPEED;
            } else if (InputHelper.scrolledUp) {
                this.scrollTargetY -= Settings.SCROLL_SPEED;
            }
            if (InputHelper.justClickedLeft) {
                this.grabbedScreen = true;
                this.grabStartY = (float)y - this.scrollTargetY;
            }
        } else if (InputHelper.isMouseDown) {
            this.scrollTargetY = (float)y - this.grabStartY;
        } else {
            this.grabbedScreen = false;
        }
        this.scrollY = MathHelper.scrollSnapLerpSpeed(this.scrollY, this.scrollTargetY);
        this.resetScrolling();
    }

    private void calculateScrollBounds() {
        this.scrollUpperBound = !UnlockTracker.isCharacterLocked("Crowbot") ? 2400.0f * Settings.scale : (!UnlockTracker.isCharacterLocked("The Silent") ? 2000.0f * Settings.scale : 1600.0f * Settings.scale);
        this.scrollLowerBound = 100.0f * Settings.scale;
    }

    private void resetScrolling() {
        if (this.scrollTargetY < this.scrollLowerBound) {
            this.scrollTargetY = MathHelper.scrollSnapLerpSpeed(this.scrollTargetY, this.scrollLowerBound);
        } else if (this.scrollTargetY > this.scrollUpperBound) {
            this.scrollTargetY = MathHelper.scrollSnapLerpSpeed(this.scrollTargetY, this.scrollUpperBound);
        }
    }

    public void open() {
        this.scrollTargetY = 0.0f;
        this.debugCharacterUnlock();
        CardCrawlGame.sound.play("DECK_OPEN", 0.1f);
        this.targetX = SHOW_X;
        this.button.show(TEXT[0]);
        this.screenUp = true;
        CardCrawlGame.mainMenuScreen.darken();
    }

    private void debugCharacterUnlock() {
        if (Settings.isInfo) {
            for (String s : UnlockTracker.lockedCharacters) {
                UnlockTracker.hardUnlockOverride(s);
            }
            UnlockTracker.hardUnlockOverride("GHOST");
            UnlockTracker.hardUnlockOverride("GUARDIAN");
            UnlockTracker.hardUnlockOverride("SLIME");
            UnlockTracker.hardUnlockOverride("CHAMP");
            UnlockTracker.hardUnlockOverride("AUTOMATON");
            UnlockTracker.hardUnlockOverride("COLLECTOR");
            UnlockTracker.hardUnlockOverride("CROW");
            UnlockTracker.hardUnlockOverride("DONUT");
            UnlockTracker.hardUnlockOverride("WIZARD");
        }
    }

    public void hide() {
        CardCrawlGame.sound.play("DECK_CLOSE", 0.1f);
        this.targetX = HIDE_X;
        this.button.hide();
        this.screenUp = false;
        this.currentChar = null;
        CardCrawlGame.mainMenuScreen.lighten();
    }

    public static void updateFurthestAscent(int floor) {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                ironclad.furthestAscent(floor);
                break;
            }
            case THE_SILENT: {
                silent.furthestAscent(floor);
                break;
            }
            case CROWBOT: {
                crowbot.furthestAscent(floor);
            }
        }
    }

    public static void updateHighestScore(int score) {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                ironclad.highestScore(score);
                break;
            }
            case THE_SILENT: {
                silent.highestScore(score);
                break;
            }
            case CROWBOT: {
                crowbot.highestScore(score);
            }
        }
    }

    public static void updateHighestDailyScore(int score) {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                ironclad.highestDaily(score);
                break;
            }
            case THE_SILENT: {
                silent.highestDaily(score);
                break;
            }
            case CROWBOT: {
                crowbot.highestDaily(score);
            }
        }
    }

    public static void updateVictoryTime(long time) {
        logger.info("Saving fastest victory...");
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                ironclad.updateFastestVictory(time);
                break;
            }
            case THE_SILENT: {
                silent.updateFastestVictory(time);
                break;
            }
            case CROWBOT: {
                crowbot.updateFastestVictory(time);
            }
        }
    }

    public static void incrementCrystalFed(int amount) {
        logger.info("Feeding Neow");
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                ironclad.incrementCrystalsFed(amount);
                break;
            }
            case THE_SILENT: {
                silent.incrementCrystalsFed(amount);
                break;
            }
            case CROWBOT: {
                crowbot.incrementCrystalsFed(amount);
            }
        }
    }

    public static void incrementFloorClimbed() {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                ironclad.incrementFloorClimbed();
                break;
            }
            case THE_SILENT: {
                silent.incrementFloorClimbed();
                break;
            }
            case CROWBOT: {
                crowbot.incrementFloorClimbed();
            }
        }
    }

    public static void incrementVictory(AbstractPlayer.PlayerClass c) {
        switch (c) {
            case IRONCLAD: {
                ironclad.incrementVictory();
                break;
            }
            case THE_SILENT: {
                silent.incrementVictory();
                break;
            }
            case CROWBOT: {
                crowbot.incrementVictory();
            }
        }
    }

    public static void incrementDeath(AbstractPlayer.PlayerClass c) {
        switch (c) {
            case IRONCLAD: {
                ironclad.incrementDeath();
                break;
            }
            case THE_SILENT: {
                silent.incrementDeath();
                break;
            }
            case CROWBOT: {
                crowbot.incrementDeath();
            }
        }
    }

    public static void incrementEnemySlain() {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                ironclad.incrementEnemySlain();
                break;
            }
            case THE_SILENT: {
                silent.incrementEnemySlain();
                break;
            }
            case CROWBOT: {
                crowbot.incrementEnemySlain();
            }
        }
    }

    public static void incrementBossSlain() {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                ironclad.incrementBossSlain();
                break;
            }
            case THE_SILENT: {
                silent.incrementBossSlain();
                break;
            }
            case CROWBOT: {
                crowbot.incrementBossSlain();
            }
        }
    }

    public static void incrementPlayTime(long time) {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                ironclad.incrementPlayTime(time);
                break;
            }
            case THE_SILENT: {
                silent.incrementPlayTime(time);
                break;
            }
            case CROWBOT: {
                crowbot.incrementPlayTime(time);
            }
        }
    }

    public void render(SpriteBatch sb) {
        this.renderStatScreen(sb);
        this.button.render(sb);
    }

    private void renderStatScreen(SpriteBatch sb) {
        this.renderY = this.scrollY;
        this.renderHeader(sb, NAMES[0]);
        this.renderCharacterStats(sb, all);
        this.renderY -= 700.0f * Settings.scale;
        this.renderHeader(sb, NAMES[1]);
        achievements.render(sb, this.renderY);
        this.renderY -= 1400.0f * Settings.scale;
        this.renderHeader(sb, NAMES[2]);
        this.renderCharacterStats(sb, ironclad);
        if (!UnlockTracker.isCharacterLocked("The Silent")) {
            this.renderY -= 400.0f * Settings.scale;
            this.renderHeader(sb, NAMES[3]);
            this.renderCharacterStats(sb, silent);
        }
    }

    private void renderHeader(SpriteBatch sb, String text) {
        FontHelper.renderSmartText(sb, FontHelper.charTitleFont, text, this.screenX + 50.0f * Settings.scale, this.renderY + 850.0f * Settings.scale, 9999.0f, 32.0f * Settings.scale, Settings.CREAM_COLOR);
    }

    private void renderCharacterStats(SpriteBatch sb, CharStat stat) {
        FontHelper.renderSmartText(sb, FontHelper.eventBodyText, stat.info, this.screenX + 75.0f * Settings.scale, this.renderY + 766.0f * Settings.scale, 9999.0f, 38.0f * Settings.scale, Settings.CREAM_COLOR);
        if (stat.info2 != null) {
            FontHelper.renderSmartText(sb, FontHelper.eventBodyText, stat.info2, this.screenX + 675.0f * Settings.scale, this.renderY + 766.0f * Settings.scale, 9999.0f, 38.0f * Settings.scale, Settings.CREAM_COLOR);
        }
    }

    public boolean statScreenUnlocked() {
        boolean temp = false;
        if (StatsScreen.ironclad.bossKilled > 0 || StatsScreen.ironclad.numDeath > 0) {
            temp = true;
        }
        return temp;
    }

    public boolean dailiesUnlocked() {
        boolean temp = false;
        if (StatsScreen.ironclad.furthestAscent > 17 || StatsScreen.silent.furthestAscent > 17) {
            temp = true;
        }
        if (Settings.isDemo) {
            return false;
        }
        return temp;
    }

    public boolean trialsUnlocked() {
        boolean temp = false;
        if (StatsScreen.ironclad.numVictory > 0 || StatsScreen.silent.numVictory > 0) {
            temp = true;
        }
        return temp;
    }
}

